<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform"%>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form"%>

<%@ attribute name="page" required="true" rtexprvalue="true"%>
<%@ attribute name="obj" required="true" rtexprvalue="true"%>
<%@ attribute name="cssClass" required="false" rtexprvalue="true"%>
<%@ attribute name="tooltip" required="false" rtexprvalue="true"%>
<%@ attribute name="readonly" required="false" rtexprvalue="true"%>
<%@ attribute name="required" required="false" rtexprvalue="true"%>
<%@ attribute name="showTitle" required="false" rtexprvalue="true"%>
<%@ attribute name="options" required="false" rtexprvalue="true"%>
<%@ attribute name="columns" required="false" rtexprvalue="true"%>

<re:mark>Display a single dropdown box sourced from </re:mark>

<re:mark>Get the tooltip based on objName and objVar</re:mark>
<c:set var="tooltip_msg">
	<wmsform:getlocaletooltip page="${page}" obj="${obj}" tooltip="${tooltip}" />
</c:set>

<c:if test="${ empty columns }">
	<c:set var="columns">1</c:set>
</c:if>

<c:set var="ctrlGroupClass">
	<wmsform:getctrlgroupclass obj="${obj}" />
</c:set>

<div class="${ctrlGroupClass}" id="${obj}CtrlGroupEdit">
	<re:mark>Title</re:mark>
	<c:if test="${ empty showTitle}">
		<div class="row">
			<label class="control-label"> <wmsform:getlocalestring page="${page}" obj="${obj}" />
			</label>
			<c:if test="${! empty required}">
			*
			</c:if>
		</div>
	</c:if>
	<re:mark>Get list of items</re:mark>
	<c:choose>
		<c:when test="${ empty options }">
			<c:set var="optionsList">
				<wmsform:objvaluearray page="${page}" obj="${obj}Options" leavecomma="yes" />
			</c:set>
		</c:when>
		<c:otherwise>
			<c:set var="optionsList">
				${options}
			</c:set>
		</c:otherwise>
	</c:choose>

	<c:set var="rows">
		${(fn:length(fn:split(optionsList,','))) div columns}
	</c:set>
	<c:set var="count">0</c:set>
	<re:mark>Get currently set value</re:mark>
	<c:set var="objValue">
		<wmsform:objvaluearray page="${page}" obj="${obj}" />
	</c:set>
	<c:set var="colmdsize">
		<fmt:formatNumber value="${12 div columns}" maxFractionDigits="0" />
	</c:set>
	<re:mark>Display the radiobuttons picker</re:mark>
	<c:forEach var="itemKey" items="${fn:split(optionsList,',')}">
			<c:set var="valueString" value="${fn:trim(itemKey)}" />
			<c:choose>
				<c:when test="${valueString == fn:trim(objValue)}">
				<div style="float:left;margin-right:10px;"><input type="radio" name="${obj}" id="${obj}" value="${valueString}" checked> <wmsform:getlocalestring
								page="${page}" obj="${obj}.${valueString}" />
				
				</c:when>
				<c:otherwise>
					<div style="float:left;margin-right:10px;"><input type="radio" name="${obj}" id="${obj}" value="${valueString}"> <wmsform:getlocalestring
								page="${page}" obj="${obj}.${valueString}" />
					
				</c:otherwise>
				
			</c:choose>
			<c:set var="objhelp">
				<wmsform:getlocalestring page="${page}" obj="${obj}.${valueString}.help" />
			</c:set>
			<c:if test='${ not (fn:endsWith(objhelp,"help"))}'>
				<div class="indent1">
					<span class="help-block">${fn:trim(objhelp)}</span>
				</div>
			</c:if>
		</div>
		<c:set var="count">${count+1}</c:set>
		<c:if test="${(count % (rows-(rows%1)) == 0 and count > 0) or count == (fn:length(fn:split(optionsList,','))) }">
			</div>
		</c:if>
	</c:forEach>

	<re:mark>Errors and warnings</re:mark>
	<wmsform:errors path="${obj}" />
	<wmsform:warnings path="${obj}" />
</div>