<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>

<%@ attribute name="obj" required="true" rtexprvalue="true" %>

<c:set var="cssClass" value="form-group"/>
<spring:hasBindErrors name="formData">
	<c:forEach var="error" items="${errors.allErrors}">
		<c:if test="${ error.field==obj}">
			<c:set var="cssClass" value="form-group has-error"/>
	    </c:if>
    </c:forEach>
</spring:hasBindErrors>
<c:if test="${not empty requestScope.formData.warningMessages[obj]}">
	<c:set var="cssClass" value="form-group has-warning"/>
</c:if>
${cssClass}

