<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="wmsdialog" tagdir="/WEB-INF/tags/wmsdialog" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<re:mark>edit buyDRM stream map tables</re:mark>

<c:set var="obj" >
	buyDRMStreamMapList
</c:set>

<div class="advanced-table-title">
	<h4 id="buyDRMStreamMaps" class="control-label"><wmsform:getlocalestring page="${page}" obj="buyDRMStreamMaps"/></h4>
	<wmsform:button page="${page}" obj="addStreamMap" onClick="javascript:streamMapShow(-1)" icon="fa fa-plus"/>
</div>

<table class="table table-striped" id="streamMapTable">
</table>


<wmsdialog:buydrmstreammap page="${page}"/>

<c:set var="streamNameLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.streamName"/>
</c:set>
<c:set var="streamNameInfo">
	<wmsform:getlocalestring page="${page}" obj="${obj}.streamNameInfo"/>
</c:set>
<c:set var="streamNameAction">
	<wmsform:getlocalestring page="${page}" obj="${obj}.streamNameAction"/>
</c:set>
<c:set var="keyIDLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.keyID"/>
</c:set>
<c:set var="contentIDLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.contentID"/>
</c:set>
<c:set var="mediaIDLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.mediaID"/>
</c:set>
<c:set var="actionLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.action"/>
</c:set>

<script>
var tblDataStreamMap = new Array();
var tblIdxStreamMap=0;

initTableDataStreamMap();
updateTableStreamMap();

function initTableDataStreamMap()
{
	<c:set var="count" value="0"/>
	<c:forEach items="${requestScope.formData[obj]}" var="item">
		var newItem = new Object();
		newItem.orgIdx = tblIdxStreamMap++;
		newItem.removed = "${item['removed']}"==="true";
		newItem.order = "${item['order']}";
		newItem.streamName = "${item['streamName']}";
		<spring:bind path="${obj}[${count}].streamName">
		  <c:forEach items='${status.errorMessages}' var='error'>
			newItem.streamNameError= "${error}";
		  </c:forEach>
		</spring:bind>
		newItem.keyID = "${item['keyID']}";
		<spring:bind path="${obj}[${count}].keyID">
		  <c:forEach items='${status.errorMessages}' var='error'>
			newItem.keyIDError= "${error}";
		  </c:forEach>
		</spring:bind>
		newItem.contentID = "${item['contentID']}";
		<spring:bind path="${obj}[${count}].contentID">
		  <c:forEach items='${status.errorMessages}' var='error'>
			newItem.contentIDError= "${error}";
		  </c:forEach>
		</spring:bind>
		newItem.mediaID = "${item['mediaID']}";
		<spring:bind path="${obj}[${count}].mediaID">
		  <c:forEach items='${status.errorMessages}' var='error'>
			newItem.mediaIDError= "${error}";
		  </c:forEach>
		</spring:bind>
		tblDataStreamMap.push(newItem);
		<c:set var="count" value="${count + 1}"/>
	</c:forEach>
}

function updateTableStreamMap()
{
	var tbl = document.getElementById('streamMapTable');
	if(tbl==null)
		return;
	while (tbl.firstChild) {
		tbl.removeChild(tbl.firstChild);
	}
	var tblString="";
	tblString+="<tr>";
	tblString+="<th width='40%'>${streamNameLabel}</th>";
	tblString+="<th width='40%'>${streamNameInfo}</th>";
	tblString+="<th width='20%'>${streamNameAction}</th>";
	tblString+="</tr>";

	var goodItems=0;
	for (tblItem in tblDataStreamMap) {
		if(!tblDataStreamMap[tblItem].removed)
		{
			goodItems++;
		}
	}
	var displayed=0;
	for (tblItem in tblDataStreamMap) {
		if(tblDataStreamMap[tblItem].removed)
		{
			tblString+="<tr style='display:none'><td>";
		}
		else {
			tblString+="<tr>";
		}
		
		tblString+="<input id='${obj}"+tblItem+".order' name='${obj}["+tblItem+"].order' type='hidden' value='"+tblDataStreamMap[tblItem].order+"'>";			
		tblString+="<input id='${obj}"+tblItem+".removed' name='${obj}["+tblItem+"].removed' type='hidden' value='"+tblDataStreamMap[tblItem].removed+"'>";			

		if(tblDataStreamMap[tblItem].removed)
		{
			tblString+="</td></tr>";
			tblString+="<tr style='display:none'></tr>";
		}
		else 
		{	
			tblString+="<td>";
			tblString+=showInput(tblItem,"streamName",tblDataStreamMap[tblItem].streamName,tblDataStreamMap[tblItem].streamNameError);
			tblString+="</td>";
			tblString+="<td><label>${keyIDLabel}: </label>";
			tblString+=showInput(tblItem,"keyID",tblDataStreamMap[tblItem].keyID,tblDataStreamMap[tblItem].keyIDError);
			tblString+="<label>${contentIDLabel}: </label>";
			tblString+=showInput(tblItem,"contentID",tblDataStreamMap[tblItem].contentID,tblDataStreamMap[tblItem].contentIDError);
			tblString+="<label>${mediaIDLabel}: </label>";
			tblString+=showInput(tblItem,"mediaID",tblDataStreamMap[tblItem].mediaID,tblDataStreamMap[tblItem].mediaIDError);
			tblString+="</td>";			
			if(displayed==0 && goodItems>1) 
			{
				tblString+="<td nowrap class='action-icons-triple'><div class='row'>";
				tblString+="<div class='col-md-4 sort-down sorth-with-edit'><a href='javascript:moveStreamDown("+ tblItem + ")'><i class='fa fa-chevron-down fa-lg icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Move down in list'></i></a></div>";
				tblString+="<div class='col-md-4 trash-icon'><a href='javascript:streamMapShow("+tblItem+")'><i class='fa fa-pencil fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Edit stream map'></i></a></div>";				
				tblString+="<div class='col-md-4 trash-icon'><a href='javascript:removeStream("+tblItem+")'><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='right' data-toggle='tooltip' data-delay='250' data-original-title='Delete stream map'></i></a></div>";				
				tblString+="</div></td>"
			}
			if(displayed!=0 && displayed==goodItems-1) 
			{
				tblString+="<td nowrap class='action-icons-triple'><div class='row'>";
				tblString+="<div class='col-md-4 sorth-with-edit'><a href='javascript:moveStreamUp("+ tblItem + ")'><i class='fa fa-chevron-up fa-lg icon-standalone-link'  title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Move up in list'></i></a></div>";
				tblString+="<div class='col-md-4 trash-icon'><a href='javascript:streamMapShow("+tblItem+")'><i class='fa fa-pencil fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Edit this stream map'></i></a></div>";				
				tblString+="<div class='col-md-4 trash-icon'><a href='javascript:removeStream("+tblItem+")'><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='right' data-toggle='tooltip' data-delay='250' data-original-title='Delete this stream map'></i></a></div>";				
				tblString+="</div></td>"
			}
			if(displayed!=goodItems-1 && displayed!=0 && goodItems!=1)
			{
				tblString+="<td nowrap class='action-icons-triple' ><div class='row'>";
				tblString+="<div class='col-md-4 sorth-with-edit'><a href='javascript:moveStreamUp("+ tblItem + ")'><i class='fa fa-chevron-up fa-lg icon-standalone-link'  title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Move up in list'></i></a><br>";
				tblString+="<a href='javascript:moveStreamDown("+ tblItem + ")'><i class='fa fa-chevron-down fa-lg icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Move down in list'></i></a></div>";
				tblString+="<div class='col-md-4 trash-icon'><a href='javascript:streamMapShow("+tblItem+")'><i class='fa fa-pencil fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Edit this stream map'></i></a></div>";				
				tblString+="<div class='col-md-4 trash-icon'><a href='javascript:removeStream("+tblItem+")'><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='right' data-toggle='tooltip' data-delay='250' data-original-title='Delete this stream map'></i></a></div>";				
				tblString+="</div></td>"
			}
			if(goodItems==1)
			{
				tblString+="<td nowrap ><div class='row'>";
				tblString+="<div class='col-md-6 trash-icon'><a href='javascript:streamMapShow("+tblItem+")'><i class='fa fa-pencil fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Edit this stream map'></i></a></div>";				
				tblString+="<div class='col-md-6 trash-icon'><a href='javascript:removeStream("+tblItem+")'><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='right' data-toggle='tooltip' data-delay='250' data-original-title='Delete this stream map'></i></a></div>";				
				tblString+="</div></td>"

			}
			tblString+="</tr>";
			displayed++;
		}
	}
	$('#streamMapTable').html(tblString);
}

function showInput(tblItem,field,valueStr,errorStr)
{
	if(errorStr != undefined)
	{
		retVal="<div class='form-group error' id='${obj}CtrlGroup'>";
	}
	else {
		retVal="<div class='form-group' id='${obj}CtrlGroup'>";		
	}
	retVal+="<input id='${obj}"+tblItem+"."+field+"' name='${obj}["+tblItem+"]."+field+"' value='"+valueStr+"' type='hidden' >";
	retVal+=valueStr;
	if(errorStr != undefined)
	{
		retVal+="<span class='help-block-has-error'>"+errorStr+"</span>";
	}
	retVal+="</div>";
	return retVal;
}
function removeStream(orgIdx)
{
	tblDataStreamMap[orgIdx].removed=true;
	tblDataStreamMap[orgIdx].enabled=false;
	if(tblDataStreamMap[orgIdx].added) //value did not exsits before and was just added
	{
		tblDataStreamMap.splice(orgIdx,1); //remove it
	}
	updateTableStreamMap();
}
function moveStreamDown(idx)
{
	if(idx >= tblDataStreamMap.length-1) {
		return;
	}
	//move swap the .order of local var tablData
	var a = tblDataStreamMap[idx];
	var b= tblDataStreamMap[idx+1];
	tblDataStreamMap[idx]=b;
	tblDataStreamMap[idx+1]=a;
	a.order=idx+1;
	b.order=idx;
	updateTableStreamMap();
}
function moveStreamUp(idx)
{
	if(idx <=0) {
		return;
	}
	var a = tblDataStreamMap[idx];
	var b= tblDataStreamMap[idx-1];
	tblDataStreamMap[idx]=b;
	tblDataStreamMap[idx-1]=a;
	a.order=idx-1;
	b.order=idx;
	updateTableStreamMap();
}
</script>
<script type="text/javascript">
    $(function () {
        $("[data-toggle='tooltip']").tooltip();
    });
</script>