<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="wmsdialog" tagdir="/WEB-INF/tags/wmsdialog" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<re:mark>edit smil file streams tables</re:mark>

<c:set var="obj" >
	streams
</c:set>

<table class="table table-striped" id="smilFileStreams">
</table>
<c:set var="sourceLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.source"/>
</c:set>
<c:set var="languageLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.language"/>
</c:set>
<c:set var="typeLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.type"/>
</c:set>
<c:set var="actionLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.action"/>
</c:set>

<script>


updateTableSMILStreams();


function updateTableSMILStreams()
{
	var tbl = document.getElementById('smilFileStreams');
	if(tbl==null)
		return;
	while (tbl.firstChild) {
		tbl.removeChild(tbl.firstChild);
	}
	var tblString="";
	tblString+="<tr>";
	tblString+="<th style='vertical-align:bottom'>${sourceLabel}</th>";
	tblString+="<th style='vertical-align:bottom'>${languageLabel}</th>";
	tblString+="<th style='vertical-align:bottom'>${typeLabel}</th>";
	tblString+="<th style='vertical-align:bottom;width:60px;'>${actionLabel}</th>";
	tblString+="</tr>";

	var goodItems=0;
	for (tblItem in tblDataSMILStream) {
		if(!tblDataSMILStream[tblItem].removed)
		{
			goodItems++;
		}
	}
	var displayed=0;
	for (tblItem in tblDataSMILStream) {
		if(tblDataSMILStream[tblItem].removed)
		{
			tblString+="<tr style='display:none'><td>";
		}
		else {
			tblString+="<tr>";
		}
		
		tblString+="<input id='${obj}"+tblItem+".removed' name='${obj}["+tblItem+"].removed' type='hidden' value='"+tblDataSMILStream[tblItem].removed+"'>";			
		tblString+="<input id='${obj}"+tblItem+".orgIdx'  name='${obj}["+tblItem+"].orgIdx'  type='hidden' value='"+tblDataSMILStream[tblItem].orgIdx+"'>";			
		
		if(tblDataSMILStream[tblItem].removed)
		{
			tblString+="</td></tr>";
			tblString+="<tr style='display:none'></tr>";
		}
		else 
		{	
			tblString+="<td>";
			tblString+=showSMILStreamInput(tblItem,"src",tblDataSMILStream[tblItem].src,"");
			tblString+="</td>";
			tblString+="<td class=\"breakall\">";
			tblString+=showSMILStreamInput(tblItem,"systemLanguage",tblDataSMILStream[tblItem].systemLanguage,"");
			tblString+="</td>";
			tblString+="<td class=\"breakall\">";
			tblString+=showSMILStreamInput(tblItem,"type",tblDataSMILStream[tblItem].type,"");
			tblString+="</td>";
			
			if(displayed==0 && goodItems>1) 
			{
				tblString+="<td class='action-icons'><div class='row'>";
				tblString+="<div class='col-md-6 sort-down'><a href='javascript:moveSMILStreamDown("+ tblItem + ")' ><i class='fa fa-chevron-down fa-lg icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Move this stream down'></i></a></div>";
				//tblString+="<div class='col-md-6 trashicon'><a href='javascript:removeSMILStream2("+tblItem+")' ><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='right' data-toggle='tooltip' data-delay='250' data-original-title='Remove this stream'></i></a></div>";				
				tblString+="</div></td>";	
			}
			if(displayed!=0 && displayed==goodItems-1) 
			{
				tblString+="<td nowrap class='action-icons'><div class='row'>";
				tblString+="<div class='col-md-6'><a href='javascript:moveSMILStreamUp("+ tblItem + ")'><i class='fa fa-chevron-up fa-lg icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Move this stream up'></i></a></div>";
				//tblString+="<div class='col-md-6 trash-icon'><a href='javascript:removeSMILStream2("+tblItem+")' ><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='right' data-toggle='tooltip' data-delay='250' data-original-title='Remove this stream'></i></a></div>";				
				tblString+="</div></td>";	
			}
			if(displayed!=goodItems-1 && displayed!=0 && goodItems!=1)
			{
				tblString+="<td nowrap class='action-icons'><div class='row'>";
				tblString+="<div class='col-md-6'><a href='javascript:moveSMILStreamUp("+ tblItem + ")'><i class='fa fa-chevron-up fa-lg icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Move this stream up'></i></a><br>";
				tblString+="<a href='javascript:moveSMILStreamDown("+ tblItem + ")' ><i class='fa fa-chevron-down fa-lg icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Move this stream down'></i></a></div>";
				//tblString+="<div class='col-md-6 trash-icon'><a href='javascript:removeSMILStream2("+tblItem+")' ><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='right' data-toggle='tooltip' data-delay='250' data-original-title='Remove this stream'></i></a></div>";				
				tblString+="</div></td>";	
			}
			if(goodItems==1)
			{
				tblString+="<td class='action-icons'><div class='row'>";
				//tblString+="<a href='javascript:removeSMILStream2("+tblItem+")' ><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='right' data-toggle='tooltip' data-delay='250' data-original-title='Remove this stream'></i></a>";				
				tblString+="</div></td>";	
			}
	
			tblString+="</tr>";
			displayed++;
		}
	}

	$('#smilFileStreams').html(tblString);
}

function showSMILStreamInput(tblItem,field,valueStr,errorStr)
{
	if(errorStr != undefined)
	{
		retVal="<div class='form-group error' id='${obj}CtrlGroup'>";
	}
	else {
		retVal="<div class='form-group' id='${obj}CtrlGroup'>";		
	}
	retVal+="<input id='${obj}"+tblItem+"."+field+"' name='${obj}["+tblItem+"]."+field+"' value='"+valueStr+"' type='hidden' >";
	retVal+=valueStr;
	if(errorStr != undefined)
	{
		retVal+="<span class='help-block-has-error'>"+errorStr+"</span>";
	}
	retVal+="</div>";
	return retVal;
}

/*
function removeSMILStream2(orgIdx)
{
	tblDataSMILStream[orgIdx].removed=true;
	if(tblDataSMILStream[orgIdx].added) //value did not exsits before and was just added
	{
		tblDataSMILStream.splice(orgIdx,1); //remove it
	}
	updateTableSMILStreams();
}
*/

function swapSMILStreamEnable(idx)
{
	tblDataSMILStream[idx].enable=!tblDataSMILStream[idx].enable;
}

function moveSMILStreamDown(idx)
{
	if(idx >= tblDataSMILStream.length-1) {
		return;
	}
	//move swap the .order of local var tablData
	var a = tblDataSMILStream[idx];
	var b= tblDataSMILStream[idx+1];
	tblDataSMILStream[idx]=b;
	tblDataSMILStream[idx+1]=a;
	a.order=idx+1;
	b.order=idx;
	updateTableSMILStreams();
}

function moveSMILStreamUp(idx)
{
	if(idx <=0) {
		return;
	}
	var a = tblDataSMILStream[idx];
	var b= tblDataSMILStream[idx-1];
	tblDataSMILStream[idx]=b;
	tblDataSMILStream[idx-1]=a;
	a.order=idx-1;
	b.order=idx;
	updateTableSMILStreams();
}
</script>
<script type="text/javascript">
    $(function () {
        $("[data-toggle='tooltip']").tooltip();
    });
</script>