<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="wmsdialog" tagdir="/WEB-INF/tags/wmsdialog" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<re:mark>Display all media cache stores table</re:mark>

<c:set var="obj" >
	stores
</c:set>
<table class="table table-striped">
	<tr>
		<th><wmsform:getlocalestring page="${page}" obj="${obj}.name"/></th>
		<th><wmsform:getlocalestring page="${page}" obj="${obj}.path"/></th>
		<th><wmsform:getlocalestring page="${page}" obj="${obj}.action"/></th>
	</tr>
	<c:forEach items="${requestScope.formData[obj]}" var="item">
		<tr>
			<td><a href='javascript:showMediaCacheStore("${item["storeName"]}")'>${item['storeName']}</a></td>
			<td class="breakall">${item['path']}</td>
			<td>
				<sec:authorize access="hasAnyRole('admin')">
				<a href='javascript:showEditMediaCacheStore("${item["storeName"]}")' ><i class='fa fa-pencil fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Edit this media cache store'></i></a>
					<c:if test="${item['storeName']!='default'}">
						<a href='javascript:removeStore("${item["storeName"]}")'><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Delete this media cache store'></i></a>
					</c:if>
				</sec:authorize>
			</td>
		</tr>
	</c:forEach>
</table>
<wmsdialog:deletemediacachestore page="mediaCache"/>

<script>

function removeStore(name)
{
	deleteStoreName=name;
	deleteMediaCacheStoreShow();
}

function showMediaCacheStore(name)
{
	if(name!="[new]")
	{
		loadAjaxMainContent("server/mediacachestore/view.htm", "storeName="+name);
	}
}
function showEditMediaCacheStore(name)
{
	lastTab='Basic';
	loadAjaxMainContent('server/mediacachestore/edit.htm','storeName='+name+'&action=quickEdit');
}
</script>
<script type="text/javascript">
    $(function () {
        $("[data-toggle='tooltip']").tooltip();
    });
</script>