// add iframe element, which is used internally to retrieve log-in/out response from wowza.com
$('body').append('<iframe id="response" height="0" width="0" style="border:0"></iframe>');

var WOWZA = WOWZA || {};
WOWZA.Facebook = WOWZA.Facebook || {};

var location_auth = null;
var location_query = null;
var accessToken = null;
var lastResult = "waiting";
var cancel = false;
var scope = ["publish_video", "manage_pages", "publish_pages", "publish_to_groups", "pages_show_list", "business_management"];
var reauth = true;
var ajaxTimeout = 10000;
var appId = null;
var facebookApiVer = "v3.0";

WOWZA.Facebook.init = function(permissions, wowzaURL, wowzaAppId) {
	//console.log("WOWZA.Facebook.init");

	if (!permissions || !wowzaURL) {
		alert("WOWZA.Facebook.init: Internal Error!");
	}

	accessToken = null;
	lastResult = "waiting";
	cancel = false;
	scope = permissions;
	location_auth = wowzaURL + "/fb_auth" + ".php";
	location_query = wowzaURL + "/fb_query" + ".php";
	appId = wowzaAppId;

	$.ajaxSetup({timeout:ajaxTimeout});
};

// WOWZA.Facebook.login() - logs into Facebook, primarily to attain user access code
//   Objects that may be returned to callback:
//     {result: "success", reason: "logged-in"}
//     {result: "fail", reason: "canceled by user"}
//     {result: "fail", reason: "closed unexpectedly"}
//     {result: "fail", reason: "insufficient permissions"}
//     {result: "fail", reason: "facebook api error"}
//     {result: "fail", reason: "unknown"}
//
//   returns "pending" - in progress
//           "done" - already logged-in
//           "fail" - failure, such as bad callback or init() not called

WOWZA.Facebook.login = function(cb) {
	if (!cb || !location_auth) {
		alert("WOWZA.Facebook.login: Internal Error!");
		return "fail";
	}

	accessToken = null;
	lastResult = "waiting";
	cancel = false;

	var ref = null;
	var start = null;

	function poll_login() {
		if (lastResult == "success") {
			if (ref) ref.close(); ref = null;
			window.removeEventListener('message', messageHandler);
			$("#response").attr('src', location_auth + "?ax=kill");

			if (accessToken != null) 			{
				//console.log("WOWZA.Facebook.login.poll_login: got accessToken: " + accessToken);
				//console.log("WOWZA.Facebook.login.poll_login: got accessToken!");

				// check permissions
				verifyPermissions();
			}
			else {
				var msg = "WOWZA.Facebook.login.poll_login: ERROR: Got 'result:success' but no accessToken!?";
				console.log(msg);
				alert(msg);
			}
		}
		else {
			if (lastResult == "started" || lastResult == "waiting" || lastResult == "token-request-pending") {
				//console.log("WOWZA.Facebook.login.poll_login: no accessToken yet");
				if (cancel == true) {
					console.log("WOWZA.Facebook.login.poll_login: cancelling poll by user request");
					if (ref) ref.close(); ref = null;
					window.removeEventListener('message', messageHandler);
					$("#response").attr('src', location_auth + "?ax=kill");
					cb({result: "fail", reason: "canceled by user"});
				}
				else if (ref && ref.closed) {
					console.log("WOWZA.Facebook.login.poll_login: cancelling poll because window was closed");
					window.removeEventListener('message', messageHandler);
					$("#response").attr('src', location_auth + "?ax=kill");
					cb({result: "fail", reason: "closed unexpectedly"});
				}
				else if (lastResult == "token-request-pending" && (Date.now() - start) >= ajaxTimeout) {
					if (ref) ref.close(); ref = null;
					window.removeEventListener('message', messageHandler);
					$("#response").attr('src', location_auth + "?ax=kill");
					console.log("WOWZA.Facebook.login.poll_login: ERROR: token request timeout");
					//cb({result: "fail", reason: "token request timeout"});
					cb({result: "fail", reason: "token request timeout"});
				}
				else {
					$("#response").attr('src', location_auth + "?ax=poll");
					setTimeout( function () { poll_login(); }, 2000);
				}
			}
			else { // lastResult == "fail"; user likely didn't add approve our app to access his account at all
				if (ref) ref.close(); ref = null;
				window.removeEventListener('message', messageHandler);
				$("#response").attr('src', location_auth + "?ax=kill");
				console.log("WOWZA.Facebook.login.poll_login: ERROR: got 'result:" + lastResult + "' (probably user canceled app login)");
				//cb({result: "fail", reason: "unknown"});
				cb({result: "fail", reason: "insufficient permissions"});
			}
		}
	}

	function verifyPermissions() {
		// verifies that the user granted us the required permissions.

		WOWZA.Facebook.query("/"+facebookApiVer+"/me/permissions", null, function(response) {
			//console.log('WOWZA.Facebook.login.verifyPermissions: permissions: \n' + JSON.stringify(response));
			if (response.result == "success") {
				var declined = "";
				for (var i in response.fbResponse.data)
				{
					//console.log(WOWZA.Facebook.login.verifyPermissions: response.fbResponse.data[i].permission + ' is ' + response.fbResponse.data[i].status);
					if (response.fbResponse.data[i].status == "declined")
					{
						if (declined === "")
							declined = response.fbResponse.data[i].permission;
						else
							declined += ", " + response.fbResponse.data[i].permission;
					}
				}
				if (declined === "") {
					cb({result: "success", reason: "logged-in"});
				}
				else {
					// we didn't get all the permissions we need
					cb({result: "fail", reason: "permissions declined: " + declined});
				}
			}
			else {
				console.log("WOWZA.Facebook.login.verifyPermissions: error: " + response.reason);
				// failure in getting permissions
				cb({result: "fail", reason: "facebook api error"});
			}
		});
	}

	if (accessToken == null) {
		// start new login session with wowza server
		$("#response").attr('src', location_auth + "?ax=new");

		// open the FB login window
		var scopeParam = scope.join(',');
		var reauthParam = (reauth==true)?"&auth_type=rerequest":"";
		ref = window.open("https://www.facebook.com/dialog/oauth?client_id=" + appId + "&scope=" + scopeParam + "&response_type=code"+reauthParam + "&redirect_uri=" + location_auth + "?ax=redirect");

		if (ref) {
			// trigger polling to start in 1 sec
			setTimeout( function () {
					window.addEventListener('message', messageHandler);
					//console.log("WOWZA.Facebook.login: starting login poll");
					poll_login();
				}, 1000);
			//console.log("redirect_uri: " + location_auth + "?ax=redirect");
			start = Date.now();
			return "pending";
		}
		else {
			return "fail";
		}
	}
	else {
		console.log("WOWZA.Facebook.login: already have an accessToken (already logged-in)");
		return "done";
	}
}

// WOWZA.Facebook.logout() - logs into Facebook, primarily to attain user access code
//   Objects that may be returned to callback:
//     {result: "success", reason: "logged-out"}
//     {result: "fail", reason: "canceled by user"}
//     {result: "fail", reason: "unknown"}
//
//   returns "pending" - in progress
//           "done" - already logged-in
//           "fail" - failure, such as bad callback or init() not called
WOWZA.Facebook.logout = function(cb) {
	if (!cb || !location_auth) {
		alert("WOWZA.Facebook.logout: Internal Error!");
		return "fail";
	}

	lastResult = "waiting";
	cancel = false;
	var ref = null;

	function poll_logout() {
		if (lastResult == "logged-out") {
			//console.log("WOWZA.Facebook.logout.poll_logout: success");
			accessToken = null;
			if (ref) ref.close(); ref = null;
			window.removeEventListener('message', messageHandler);
			$("#response").attr('src', location_auth + "?ax=kill");
			cb({result: "success", reason: "logged-out"});
		}
		else {
			//console.log("WOWZA.Facebook.logout.poll_logout: still waiting to logout");
			if (cancel == true) {
				//console.log("WOWZA.Facebook.logout.poll_logout: cancelling poll");
				accessToken = null;
				if (ref) ref.close(); ref = null;
				window.removeEventListener('message', messageHandler);
				$("#response").attr('src', location_auth + "?ax=kill");
				cb({result: "fail", reason: "canceled by user"});
			}
			else {
				$("#response").attr('src', location_auth + "?ax=poll");
				setTimeout( function () { poll_logout(); }, 250);
			}
		}
	}

	if (accessToken != null) {
		//console.log("WOWZA.Facebook.logout: starting logout poll");
		setTimeout( function () {
				window.addEventListener('message', messageHandler);
				poll_logout();
			}, 250);

//		var req = 'https://www.facebook.com/logout.php?next=' + location_auth + '?ax=logout&access_token=' + accessToken;
		// because the token is encrypted, we have to ask somebody that can decrypt it to do so and then ask facebook to
		// log the user out, so we do that on fb.wowza.com as well, which ends up decrypting the token then redirects the browser
		// back to itself with the ax=logout parameter and things work as they did before.
		var req = location_auth + '?ax=logouttheuser&access_token=' + accessToken;

		console.log("WOWZA.Facebook.logout: " + req);
		ref = window.open(req);
		return "pending";
	}
	else {
		console.log("WOWZA.Facebook.logout: no accessToken (not logged-in)");
		return "done";
	}
}

WOWZA.Facebook.cancel = function() {
	cancel = true;
}

WOWZA.Facebook.getAccessToken = function() {
	return accessToken;
}

// WOWZA.Facebook.query() - makes a query to the Facebook graph apis
//   Objects that may be returned to callback:
//     {result: "success", reason: "<response data from FB>"}
//     {result: "fail", reason: "<reason msg from FB>"}
//     {result: "fail", reason: "unknown"}
//
//     returns "pending" - in progress
//             "fail" - failure, such as missing access token, a bad callback, or init() not called
WOWZA.Facebook.query = function(path, fields, cb) {
	if (! accessToken || !cb || !location_query) {
		alert("WOWZA.Facebook.query: Internal Error!");
		return "fail";
	}

	var params = {ax: "query", path: path, access_token:accessToken};
	if (fields)
		params.fields = fields;

	//console.log('WOWZA.Facebook.query: do get: ' + path);
	$.get(location_query, params, function(response){
		respJSON = JSON.parse(response);
		if (respJSON.result == "success") {
			cb({result:"success", fbResponse:respJSON.fb_response});
		}
		else {
			cb({result:"fail", reason:respJSON.error_reason});
		}
	}, "jsonp")
		.fail(function(jqXHR, textStatus, errorThrown) {
			cb({result:"fail", reason:"unknown"});
		});

	return "pending";
}

// handle messages from the wowza.com php script
function messageHandler(event) {
	// The event data is received/stored in event.data
	//console.log("WOWZA.Facebook.messageHandler: event.data: " + event.data);

	// error condition where we requested logout but user was not actually "logged into" the app from
	// Facebook's perspective, basically meaning the access token had become invalid.
	if  (lastResult == "waiting" && event.data == "") {
	    lastResult = "logged-out";
		accessToken = null;
	}
	else {
		respJSON = JSON.parse(event.data);

		if (respJSON.result != null) {
			lastResult = respJSON.result;
			// possible results are:
			//   "started", "waiting", "token-request-pending", "no-code-param", "fail", "success", "session-killed", "logged-out"
			//console.log("WOWZA.Facebook.messageHandler: result: " + lastResult);
			if (lastResult == "success")
				accessToken = respJSON.access_token;
			else if  (lastResult == "logged-out" || lastResult == "fail")
				accessToken = null;
		}
	}
}



